import { world, EntityEquippableComponent, EquipmentSlot, ItemStack, system } from "@minecraft/server";
import { addItem, config_default, getEquip, setScore, hitEvent, dead_event, config, playerKey, visualTombsConfig } from './functions.js';
const w = world.getDimension("overworld");



world.afterEvents.worldInitialize.subscribe(() => {
  w.runCommandAsync(`gamerule sendCommandFeedback false`);
  w.runCommandAsync(`gamerule showTags false`);
});

system.runInterval(() =>{
  for(let p of world.getPlayers()){
    config_default(p)
    getEquip(p)
  }
})

world.afterEvents.playerSpawn.subscribe(spawn => {
  const p = spawn.player;

  const playerUUID = p.id;

  if(!p.hasTag("addScores")){
    p.addTag("addScores")
	  p.runCommandAsync(`scoreboard objectives add modelTombs dummy`)
	  p.runCommandAsync(`scoreboard objectives add colorNameStatus dummy`)
	  p.runCommandAsync(`scoreboard players set @s modelTombs 0`)
	  p.runCommandAsync(`scoreboard players set @s colorNameStatus 0`)
    addItem(p, "new:visual_config", true, "none", [
        "\n§dAllows you to configure the viual graves",
        "§r§cThis item is not lost when you die.§r"
      ]);
  }
  if (world.getDynamicProperty("owner_uuid") === undefined) {
    world.setDynamicProperty("owner_uuid", playerUUID);
    p.sendMessage("§aYou are now the owner of this world.");
  }

  if (p.hasTag("dead")) {
    let cords, dim;

    p.getTags().forEach(tag => {
      if (tag.startsWith("cords:")) cords = tag.replace("cords:", "");
      if (tag.startsWith("dim:")) dim = tag.replace("dim:", "");
    });

    if (cords && dim) {
      playerKey(p, cords, dim);
      p.removeTag("dead");
      p.removeTag(`cords:${cords}`);
      p.removeTag(`dim:${dim}`);
    }
  }

  if (spawn.initialSpawn && !p.hasTag("key_config")) {
    const defaultProperties = {
      key_status: 0,
      owner_restriction: true,
      show_cords_item: true,
      show_cords_chat: true,
      lose_key: false,
      tombs_name: true,
      empty_inv: false,
      spawn_zombie: false,
      spawn_bones: false
    };

    Object.entries(defaultProperties).forEach(([key, value]) => {
      if (world.getDynamicProperty(key) === undefined) {
        world.setDynamicProperty(key, value);
      }
    });

    if (world.getDynamicProperty("owner_uuid") === playerUUID) {
      addItem(p, "new:config_key", true, "none", [
        "\n§dAllows you to configure the graves",
        "§r§cThis item is not lost when you die.§r"
      ]);
      p.addTag("key_config");
    } else {
      p.sendMessage("§cOnly the owner can configure graves. No special item was granted.");
    }
  }
});

world.afterEvents.entityDie.subscribe(dead => {
  const p = dead.deadEntity;
  if (!p.hasTag('dead')) {
    if(!world.getDynamicProperty("empty_inv")){
      if(!p.hasTag("empty") || p.hasTag("getHead") || p.hasTag("getChest") || p.hasTag("getLegs") || p.hasTag("getFFeet") || p.hasTag("getOff")){
        dead_event(p)
      }
      if(p.hasTag("empty") && !p.hasTag("getHead") && !p.hasTag("getChest") && !p.hasTag("getLegs") && !p.hasTag("getFFeet") && !p.hasTag("getOff")){
        p.sendMessage({translate: "action.graves.empty"})
      }
    }
    if(world.getDynamicProperty("empty_inv")){
     dead_event(p)
   }
 }
}, { entityTypes: ['minecraft:player'] });
world.afterEvents.itemUse.subscribe((data) => {
  const p = data.source;
  const itemStack = data.itemStack;
  if(world.getDynamicProperty("show_cords_item")){
    if (itemStack.typeId == "new:key") {
      if(itemStack.getLore()){
        const location = `${itemStack.getLore()[1].replace("§r§bCords: §6", "").split(",")}`;
        const dimensions = `${itemStack.getLore()[2].replace("§r§bDimension: §6", "").split(",")}`;
        const x = location.split(" ")[0];
        const y = location.split(" ")[1];
        const z = location.replace("§r", "").split(" ")[2];
        p.teleport({ x: parseFloat(x) + 0.5, y: parseFloat(y) + 1, z: parseFloat(z) + 0.5 }, { dimension: world.getDimension(dimensions) });
      }
    }
  }
  if(!world.getDynamicProperty("show_cords_item")){
    if (itemStack.typeId == "new:key") {
      p.getTags().forEach(t =>{
        if(t.startsWith(":§6")){
          let tp = t.replace(":§6", "")
          w.runCommandAsync(`tp "${p.name}" ${tp}`);
        }
      })
    }
  }
  if(itemStack.typeId == "new:config_key"){
    config(p)
  }
  if(itemStack.typeId == "new:visual_config"){
    visualTombsConfig(p)
  }
});
world.afterEvents.entityHitEntity.subscribe(ev => {
  const hit = ev.hitEntity;
  const entity = ev.damagingEntity;
  const equip = entity.getComponent(EntityEquippableComponent.componentId);
  const hand = equip?.getEquipment(EquipmentSlot.Mainhand);
  const item = new ItemStack("minecraft:air")
  if(hit.typeId === 'new:tumba' && entity.typeId === 'minecraft:player'){
    if(hand){
      if(!hand.typeId.includes('new:key')){
        entity.sendMessage({translate: "action.players.no_key"})
      }
      if(world.getDynamicProperty("owner_restriction") && world.getDynamicProperty("tombs_name")){
        if (hand.typeId === 'new:key_multi') {
          equip.setEquipment(EquipmentSlot.Mainhand, item)
          hitEvent(hit);
        }
        else if (hit.nameTag.includes(entity.name) && hand.typeId.includes('new:key')) {
          equip.setEquipment(EquipmentSlot.Mainhand, item)
          hitEvent(hit);
        }
        else if (!hit.nameTag.includes(entity.name) && hit.typeId === 'new:tumba') {
          if (hand.typeId === 'new:key2' || hand.typeId === 'new:key') {
            entity.runCommandAsync(`tellraw @s {"rawtext":[{"translate":"action.players.warn"},{"text": "${hit.nameTag}"}]}`)
          }
        }
      }
      if(!world.getDynamicProperty("show_cords_item")){
        if (hand.typeId.includes("new:key")) {
          entity.getTags().forEach(t =>{
            if(t.startsWith(":§6")){
              entity.removeTag(t)
            }
          })
        }
      }
      if(world.getDynamicProperty("owner_restriction") && !world.getDynamicProperty("tombs_name")){
        if (hand.typeId === 'new:key_multi') {
          equip.setEquipment(EquipmentSlot.Mainhand, item)
          hitEvent(hit);
        }
        hit.getTags().forEach(t =>{
          if(!t.startsWith(`${entity.nameTag}`)){
            if (hand.typeId === 'new:key2' || hand.typeId === 'new:key') {
              entity.sendMessage({translate: "action.players.warn2"})
            }
          }
          if(t.startsWith(`${entity.nameTag}`)){
           if (hand.typeId === 'new:key2' || hand.typeId === 'new:key') {
            equip.setEquipment(EquipmentSlot.Mainhand, item)
            hitEvent(hit);
          }
        }
      })
      }
      if(!world.getDynamicProperty("owner_restriction")){
        if (hand.typeId === 'new:key' || hand.typeId === 'new:key2' || hand.typeId === 'new:key_multi') {
          equip.setEquipment(EquipmentSlot.Mainhand, item)
          hitEvent(hit);
        }
      }
    }
    if(hand == undefined){
      entity.sendMessage({translate: "action.players.no_key"})
    }
  }
});